#include <algorithm>
#include <iostream>
#include <vector>


using namespace std;

/// <summary>
/// Paints the array in range [l,r] with  new_max if v[i] < new_max
/// </summary>
void paint_if_greater(vector<int>& v, int l, int r, int new_max)
{
    for (int i = l; i <= r; i++)
    {
        if (v[i] < new_max)
            v[i] = new_max;
    }
}

int Slamke(int N, int* A, int M, int* T, int* X, int* Y) {
    vector<int> max_reachable(N);
    int solution = 0;
    
    for (int i = 0; i < N; i++)
    {
        if (A[i+1] == 1)
            max_reachable[i] = 1;
    }
    for (int query_index = 0; query_index < M; query_index++)
    {
        if (T[query_index+1] == 1) // l,r query
        {
            int l = X[query_index + 1] - 1;
            int r = Y[query_index + 1] - 1;
            int max_val = *max_element(max_reachable.begin() + l, max_reachable.begin() + r + 1);
            paint_if_greater(max_reachable, l, r, max_val);
        }
        else // Point query
        {
            int pos = X[query_index + 1] - 1;
            solution = max(solution, max_reachable[pos]);
            if (max_reachable[pos] > 0)
            {
                max_reachable[pos]++;
            }
        }
    }
    return solution;
}